% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{f.nonconst.linear}
\alias{f.nonconst.linear}
\title{Function to compute the abundance of new or old RNA at time t for non-constant rates.}
\usage{
f.nonconst.linear(t, f0, so, sf, se, do, df, de)
}
\arguments{
\item{t}{time in h (can be a vector)}

\item{f0}{the abundance at time t=0}

\item{so}{synthesis date offset}

\item{sf}{synthesis date factor}

\item{se}{synthesis date exponent}

\item{do}{degradation rate offset}

\item{df}{degradation rate factor}

\item{de}{degradation rate exponent}
}
\value{
the RNA abundance at time t
}
\description{
The standard mass action kinetics model of gene expression arises from the differential equation
\eqn{df/dt = s(t) - d(t)  f(t)}, with s(t) being the synthesis rate at time t, d(t) the degradation rate at time t and \eqn{f0=f(0)} (the abundance at time 0).
Here, both s and d have the following form \eqn{s(t)=so+sf \cdot t^{se}}.
}
\seealso{
\link{f.nonconst}
}
\concept{kinetics}
