% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{DefaultSlot}
\alias{DefaultSlot}
\alias{DefaultSlot<-}
\title{Get or set the default slot for a grandR object.}
\usage{
DefaultSlot(data, value = NULL)

DefaultSlot(data) <- value
}
\arguments{
\item{data}{A grandR object}

\item{value}{the name of the new default slot}
}
\value{
Either the name of the default slot for DefaultSlot(data)
or the grandR data object having the new default slot
}
\description{
The default slot is used by default by many functions including
\code{\link{GetData}},\code{\link{GetTable}} or \code{\link{FitKinetics}}
}
\details{
The default slot can be set either by \code{data<-DefaultSlot(data,"norm")} or by \code{DefaultSlot(data)<-"norm"}.
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))

DefaultSlot(sars)
sars <- Normalize(sars)     # default behavior is to update the default slot
DefaultSlot(sars)
DefaultSlot(sars)="count"

}
\seealso{
\link{Slots}
}
\concept{grandr}
