% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestStatistic.R
\name{TestStatistic}
\alias{TestStatistic}
\title{Test Statistic for parametric regression models (abstract class)}
\description{
This is the abstract base class for test statistic objects like
\link{CondKolmY} or \link{MEP}.

Test statistics are built around the key method
\code{calc_stat()} which calculates the particular test statistic (and
x-y-values that can be used to plot the underlying process).
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TestStatistic-get_value}{\code{TestStatistic$get_value()}}
\item \href{#method-TestStatistic-calc_stat}{\code{TestStatistic$calc_stat()}}
\item \href{#method-TestStatistic-get_plot_xy}{\code{TestStatistic$get_plot_xy()}}
\item \href{#method-TestStatistic-print}{\code{TestStatistic$print()}}
\item \href{#method-TestStatistic-geom_ts_proc}{\code{TestStatistic$geom_ts_proc()}}
\item \href{#method-TestStatistic-plot}{\code{TestStatistic$plot()}}
\item \href{#method-TestStatistic-clone}{\code{TestStatistic$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestStatistic-get_value"></a>}}
\if{latex}{\out{\hypertarget{method-TestStatistic-get_value}{}}}
\subsection{Method \code{get_value()}}{
Returns the value of the test statistic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestStatistic$get_value()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
value of the test statistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestStatistic-calc_stat"></a>}}
\if{latex}{\out{\hypertarget{method-TestStatistic-calc_stat}{}}}
\subsection{Method \code{calc_stat()}}{
Calculate the value of the test statistic for given data
and a model to test for.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestStatistic$calc_stat(data, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{list()} containing the data}

\item{\code{model}}{\link{ParamRegrModel} to test for}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The modified object (\code{self}), allowing for method chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestStatistic-get_plot_xy"></a>}}
\if{latex}{\out{\hypertarget{method-TestStatistic-get_plot_xy}{}}}
\subsection{Method \code{get_plot_xy()}}{
Returns vectors of x and y that can be used to plot the
process corresponding to the test statistic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestStatistic$get_plot_xy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list with plot.x and plot.y being vectors of the same length
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestStatistic-print"></a>}}
\if{latex}{\out{\hypertarget{method-TestStatistic-print}{}}}
\subsection{Method \code{print()}}{
Overrides the print-method for objects of type
\code{TestStatistic} to only print its value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestStatistic$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The object (\code{self}), allowing for method chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestStatistic-geom_ts_proc"></a>}}
\if{latex}{\out{\hypertarget{method-TestStatistic-geom_ts_proc}{}}}
\subsection{Method \code{geom_ts_proc()}}{
Creates a line plot showing the underlying process of the
test statistic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestStatistic$geom_ts_proc(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments passed on to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 layer representing a line plot.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestStatistic-plot"></a>}}
\if{latex}{\out{\hypertarget{method-TestStatistic-plot}{}}}
\subsection{Method \code{plot()}}{
Creates a new ggplot showing the underlying process of the
test statistic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestStatistic$plot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments passed on to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot2 object representing the complete plot, including a line
geometry.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestStatistic-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TestStatistic-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestStatistic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
