% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateCovariateData.R
\name{simulateCovariateData}
\alias{simulateCovariateData}
\title{Simulate data with independent categorical covariates}
\usage{
simulateCovariateData(n, nCov = 2)
}
\arguments{
\item{n}{numner of observations to be generated for the data}

\item{nCov}{4+ number of covariates to be generated for the data, the first 4 covariates generated based on pre-specified distributions}
}
\value{
returns a data frame with covariates x1, x2, ...
}
\description{
This function generates a simulated data with independent categorical covariates. The first two covariates namely x1 and x2 are generated using random normal rnorm(n, 40, 20) and random poisson rpois(n, lambda = 4).The remaining covariates are generated at random with categories 0,1,2.
}
\examples{
simulateCovariateData(10, nCov=15)
}
