% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-colour.R, R/zxx.r
\name{scale_pattern_colour_continuous}
\alias{scale_pattern_colour_continuous}
\alias{scale_pattern_fill_continuous}
\alias{scale_pattern_fill2_continuous}
\alias{scale_pattern_color_continuous}
\title{Continuous and binned colour scales}
\usage{
scale_pattern_colour_continuous(
  ...,
  type = getOption("ggplot2.continuous.colour", default = "gradient")
)

scale_pattern_fill_continuous(
  ...,
  type = getOption("ggplot2.continuous.fill", default = "gradient")
)

scale_pattern_fill2_continuous(
  ...,
  type = getOption("ggplot2.continuous.fill", default = "gradient")
)
}
\arguments{
\item{...}{Additional parameters passed on to the scale type}

\item{type}{One of "gradient" (the default) or "viridis" indicating the
colour scale to use}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
See \code{ggplot2::scale_colour_continuous()} for more information
}
\examples{
  if (require("ggplot2")) {
    df <- data.frame(level = c("a", "b", "c", "d"),
                     outcome = c(2.3, 1.9, 3.2, 1))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = outcome),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      scale_pattern_fill_continuous()
    plot(gg)
  }
}
