% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnuplot.R
\name{scale_x_gnuplot}
\alias{scale_x_gnuplot}
\alias{scale_y_gnuplot}
\alias{gnubreaks}
\alias{gnuaxis}
\title{gnuplot-like (continuous) axes for ggplot2}
\usage{
scale_x_gnuplot(breaks = gnubreaks(), sec.axis = gnuaxis(), ...)
scale_y_gnuplot(breaks = gnubreaks(), sec.axis = gnuaxis(), ...)
gnubreaks(n = 5, padding = 0.1)
}
\arguments{
\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:extended_breaks]{scales::extended_breaks()}})
}}

\item{sec.axis}{\code{\link[ggplot2:sec_axis]{sec_axis()}} is used to specify a secondary axis.}

\item{...}{Other arguments passed on to \verb{scale_(x|y)_continuous()}}

\item{n}{The number of breaks/ticks to return}

\item{padding}{The amount of space between the outermost breaks/ticks and
the axis limits relative to the axis range. A number between
0 and 0.5.}
}
\description{
These functions set up gnuplot-like secondary axes. They also try to choose
pretty breaks/ticks for continuous data. Your mileage with the breaks/ticks
may vary, so be sure to try different settings.
}
\examples{
library(ggplot2)

ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
  geom_point() +
  scale_color_gnuplot() +
  scale_x_gnuplot() +
  scale_y_gnuplot() +
  theme_gnuplot()

}
\seealso{
The \link[labeling:labeling-package]{labeling package} for alternative
break/tick functions, and \code{\link[ggplot2:sec_axis]{ggplot2::dup_axis()}},
for which \code{gnuaxis()} is an alias
}
