% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph-documentation-with-examples.R
\name{gf_spoke_interactive}
\alias{gf_spoke_interactive}
\title{Interactive spoke plots}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain. Most users can safely ignore this argument.}

\item{gformula}{A formula with shape \code{y ~ x}. Faceting can be achieved by
including \code{|} in the formula.}

\item{data}{The data to be displayed in this layer.}

\item{tooltip}{A formula specifying a variable for tooltips, or a character vector.}

\item{data_id}{A formula or character vector specifying data identifiers
for interactive selection.}

\item{...}{Additional arguments passed to the underlying geom.}

\item{alpha, color, size, shape, fill, group, stroke}{Aesthetics passed to the geom.}

\item{xlab, ylab, title, subtitle, caption}{Labels for the plot.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{show.help}{Logical. If \code{TRUE}, display some minimal help.}

\item{inherit}{Logical. If \code{TRUE}, inherit aesthetics from previous layers.}

\item{environment}{An environment in which to evaluate the formula.}
}
\value{
A gg object that can be displayed with \code{\link[=gf_girafe]{gf_girafe()}}.
}
\description{
Creates an interactive plot using ggiraph. This function extends
\code{\link[=gf_spoke]{gf_spoke()}} with interactive features like tooltips and clickable elements.
}
\section{Additional interactive features}{

\itemize{
\item \code{onclick}: JavaScript code (as character string) executed when clicking elements.
\item Additional ggiraph aesthetics may be available depending on the geom.
}
}

\examples{
if (require(dplyr)) {
  expand.grid(x = 0:10, y = 0:10) |>
    mutate(
      direction = round(x * y / 100 * 2 * pi, 1),
      size = (20 + x + y) / 50
      ) |>
    gf_spoke_interactive(
      y ~ x, angle = ~ direction, radius = ~ size,
      tooltip = ~ paste(
        "angle:", round(direction / 2 / pi * 360, 1),
        "degrees; size =", size),
      data_id = ~ paste(x, "-", y),
      hover_nearest = TRUE
      ) |>
    gf_point() |>
    gf_girafe(
      options = list(
        opts_hover(css = "stroke: red; stroke-width: 2;", nearest_distance = 10)
      )
    )
}

}
\seealso{
\code{\link[=gf_spoke]{gf_spoke()}}, \code{\link[=gf_girafe]{gf_girafe()}}
}
