% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggmca_with_base_ref}
\alias{ggmca_with_base_ref}
\title{Plot Initial Dimensions (Active Variables) on a Multiple Correspondence Analyses}
\usage{
ggmca_with_base_ref(res.mca = res.mca, axes = c(1, 2), keep = NULL)
}
\arguments{
\item{res.mca}{An object created with \code{FactoMineR::\link[FactoMineR]{MCA}}.}

\item{axes}{The axes to print, as a numeric vector of length 2.}

\item{keep}{A character vector of the name of active variables to keep.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object to be printed in the
`RStudio` Plots pane. Possibility to add other gg objects with \code{+}.
Sending the result through \code{\link{ggi}} will draw the
interactive graph in the Viewer pane using \code{\link[ggiraph]{ggiraph}}.
}
\description{
This function mostly have an educational value : it shows the
initial dimensions of the Multiple Correspondence Analysis (active variables)
in the space built by the analysis (principal axes). To see initial
dimensions in their initial reference frame, use \code{\link[ggfacto]{ggmca_initial_dims}}.
}
\examples{
\donttest{
data(tea, package = "FactoMineR")
res.mca <- MCA2(tea, active_vars = 1:18)
ggmca_with_base_ref(res.mca)

# It is more readable to select just a few active variables
lv2_vars <- dplyr::select(tea[1:18], where(~ nlevels(.) == 2)) |> names()
ggmca_with_base_ref(res.mca, keep = lv2_vars)

lv3_vars <- dplyr::select(tea[1:18], where(~ nlevels(.) == 3)) |> names()
ggmca_with_base_ref(res.mca, keep = lv3_vars)

lv4_vars <- dplyr::select(tea[1:18], where(~ nlevels(.) == 4)) |> names()
ggmca_with_base_ref(res.mca, keep = lv4_vars)

lv6_vars <- dplyr::select(tea[1:18], where(~ nlevels(.) == 6)) |> names()
ggmca_with_base_ref(res.mca, keep = lv6_vars)
}
}
