% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-title.R
\name{layout_title}
\alias{layout_title}
\title{Annotate the whole layout}
\usage{
layout_title(title = waiver(), subtitle = waiver(), caption = waiver())
}
\arguments{
\item{title}{The text for the title.}

\item{subtitle}{The text for the subtitle for the plot which will be
displayed below the title.}

\item{caption}{The text for the caption which will be displayed in the
bottom-right of the plot by default.}
}
\value{
A \code{layout_title} object.
}
\description{
Annotate the whole layout
}
\examples{
p1 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) +
    geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) +
    geom_bar(aes(gear)) +
    facet_wrap(~cyl)
align_plots(p1, p2, p3) +
    layout_title(title = "I'm title")
}
