% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic-helper.R
\name{genomic_dist}
\alias{genomic_dist}
\title{Calculate inter-region distances for genomic rainfall plots}
\usage{
genomic_dist(region, mode = NULL)
}
\arguments{
\item{region}{A data frame with at least 3 columns: chromosome, start, and
end.}

\item{mode}{How to assign distance for intermediate regions: one of \code{"min"},
\code{"max"}, \code{"mean"}, \code{"left"}, or \code{"right"}.}
}
\value{
A data frame with an additional \code{dist} column.
}
\description{
This function computes distances between adjacent genomic regions, grouped by
chromosome. Useful for visualizing clustering or dispersion of genomic
features.
}
\details{
The distance between two adjacent regions is calculated as the number of
bases between the \strong{end position of the upstream region} and the
\strong{start position of the downstream region}. If two regions overlap or are
adjacent (<=1 bp apart), the distance is set to \code{0}. The resulting distance
is assigned to each region according to the selected \code{mode}:
\itemize{
\item \code{"left"}: assign the distance to the upstream region
\item \code{"right"}: assign to the downstream region
\item \code{"min"} / \code{"max"} / \code{"mean"}: for intermediate regions, calculate the
minimum, maximum, or average of the distances to neighboring regions
}
}
