% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxLagMissVal.R
\name{maxLagMissVal}
\alias{maxLagMissVal}
\title{Get maximum lag of missing values}
\usage{
maxLagMissVal(x, type = c("NA", "numeric"), value)
}
\arguments{
\item{x}{numeric vector.}

\item{type}{character specifying the type of missing value to consider. Default is 
\code{type="NA"}; when \code{type="numeric"}, \code{value} must be provided.}

\item{value}{numeric giving a figure to be used to fill missing values; often as part
of a pre-processing, missing values in a dataset (vector, time series, etc.)
are fill in with pre-established values.}
}
\value{
A list containing:
\item{maxLag}{numeric giving the maximum lag of missing values in \code{x}}
\item{x}{numeric vector with the original data}
\item{value}{a numeric when \code{type=numeric}, \code{NA} otherwise}
}
\description{
This function computes the maximum amount of consecutive missing values in a vector.
This quantity is also known as maximum lag, run, or record, and can be used as a
rough estimate of the quality of a dataset.
}
\examples{
v <- c(NA, 0.12, 0.58, 0.75, NA, NA, NA, 0.46, 0.97, 0.39,
       NA, 0.13, 0.46, 0.95, 0.30, 0.98, 0.23, 0.98,
       0.68, NA, NA, NA, NA, NA, 0.11, 0.10, 0.79, 0.46, 0.27,
       0.44, 0.93, 0.20, 0.44, 0.66, 0.11, 0.88)
maxLagMissVal(x=v, type="NA")

w <- c(23,3,14,3,8,3,3,3,3,3,3,3,10,14,15,3,10,3,3,6)
maxLagMissVal(x = w, type = "numeric", value = 3)
       
}
\seealso{
\code{\link[base]{rle}}
}
