% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{gecko.worldclim}
\alias{gecko.worldclim}
\title{Download worldclim files.}
\usage{
gecko.worldclim(res)
}
\arguments{
\item{res}{character. Specifies the resolution of environmental data used, either "1 km" or "10km".}
}
\description{
Download the latest version of worldclim to your gecko work directory. 
If you have not yet setup a work directory, it will be be setup as if running 
\code{\link[gecko:gecko.setDir]{gecko::gecko.setDir()}} with \code{gisPath = NULL}.
This is a large dataset that is prone to fail by timeout if downloaded 
through R. Instead of using this function you can run gecko.setDir() (if you 
haven't yet) and download the files at 
https://geodata.ucdavis.edu/climate/worldclim/2_1/base/wc2.1_30s_bio.zip or 
https://geodata.ucdavis.edu/climate/worldclim/2_1/base/wc2.1_10m_bio.zip. 
Unzip their contents correspondingly to the folders "./worldclim/1 km" or 
"./worldclim/10 km" inside the folder returned by gecko.getDir().
}
\details{
Reads a txt file pointing to where the world GIS files are stored.
}
\examples{
\dontrun{
gecko.worldclim("10 km")
}
}
