% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_cmd.R
\name{fs_cmd}
\alias{fs_cmd}
\title{FS Command Wrapper}
\usage{
fs_cmd(
  func,
  file,
  outfile = NULL,
  retimg = TRUE,
  reorient = FALSE,
  intern = FALSE,
  opts = "",
  verbose = TRUE,
  samefile = FALSE,
  opts_after_outfile = FALSE,
  frontopts = "",
  add_ext = TRUE,
  bin_app = "bin",
  ...
)
}
\arguments{
\item{func}{(character) Freesurfer function}

\item{file}{(character) image to be manipulated}

\item{outfile}{(character) resultant image name (optional)}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link[neurobase]{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{opts}{(character) operations to be passed to \code{func}}

\item{verbose}{(logical) print out command before running}

\item{samefile}{(logical) is the output the same file?}

\item{opts_after_outfile}{(logical) should \code{opts} come after
the \code{outfile} in the Freesurfer command?}

\item{frontopts}{(character) options/character to put in before filename}

\item{add_ext}{(logical) should the extension be added to
the \code{outfile}}

\item{bin_app}{(character) appendix to add to \code{\link{get_fs}}}

\item{...}{additional arguments passed to \code{\link{system}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls Freesurfer command passed to \code{func}
}
