% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asegstats2table.R
\name{asegstats2table}
\alias{asegstats2table}
\title{Parcellation Stats to Table}
\usage{
asegstats2table(
  subjects = NULL,
  inputs = NULL,
  outfile = NULL,
  measure = c("volume", "mean", "std"),
  sep = c("tab", "space", "comma", "semicolon"),
  skip = FALSE,
  subj_dir = NULL,
  opts = "",
  verbose = TRUE
)
}
\arguments{
\item{subjects}{(character) vector of subjects}

\item{inputs}{(character paths) vector of input filenames,
e.g. \code{aseg.stats}.}

\item{outfile}{(character) output filename}

\item{measure}{(character) measure to be calculated}

\item{sep}{(character) separator for the output file.  This will be
an attribute of \code{outfile}}

\item{skip}{(logical) if subject does not have parcellation, 
should the command skip that subject (\code{TRUE}) or error 
(\code{FALSE})}

\item{subj_dir}{(character path) if a different subjects directory
is to be used other than \code{SUBJECTS_DIR} from shell, it can be
specified here.  Use with care as if the command fail, it may not reset
the \code{SUBJECTS_DIR} back correctly after the error}

\item{opts}{(character) additional options to \code{asegstats2table}}

\item{verbose}{(logical) print diagnostic messages}
}
\value{
Character filename of output file, with the 
attribute of the separator
}
\description{
This function calls \code{asegstats2table} to 
convert parcellation statistics to a table
}
\examples{
if (have_fs()) {
   outfile = asegstats2table(subjects = "bert",
                    meas = "mean")
}
}
