% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect_ranges.R
\name{intersect_ranges}
\alias{intersect_ranges}
\title{intersect_ranges}
\usage{
intersect_ranges(x, srt = NULL, end = NULL, verbose = TRUE)
}
\arguments{
\item{x}{A numeric data.frame or matrix of ranges. If
just two columns are supplied, the first column is assumed
to be the srt column}

\item{srt}{If x contains more than two columns, srt is the
name of the range base column - the FAD}

\item{end}{If x contains more than two columns, end is the
name of the range top column - the LAD}

\item{verbose}{A logical indicating whether the function
should report progress to the console}
}
\value{
A matrix with three columns, indicating the intersection
(FAD and LAD) and the number of ranges that intersection
encompasses
}
\description{
Function to find the maximum intersection between a set
of numeric ranges, in this case first and last appearence
datums on taxonomic ranges.
}
\examples{
# plot an example
df <- cbind(c(1.5, 3, 2.1, 1), c(6, 5, 3.7, 10.1))
plot(1:11, ylim = c(0, 5), col = NA)
segments(x0 = c(1.5, 3, 2.1, 1), y0 = 1:4, x1 = c(6, 5, 3.7, 10.1), y1 = 1:4)
abline(v = 3, col  = "red", lty = 2)
abline(v = 3.7, col  = "red", lty = 2)
# intersect function
intersect_ranges(df)
}
