% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{plot.HRF}
\alias{plot.HRF}
\title{Plot an HRF Object}
\usage{
\method{plot}{HRF}(x, time = NULL, normalize = FALSE, show_peak = TRUE, ...)
}
\arguments{
\item{x}{An HRF object}

\item{time}{Numeric vector of time points. If NULL (default), uses
seq(0, span, by = 0.1) where span is the HRF's span attribute.}

\item{normalize}{Logical; if TRUE, normalize responses to peak at 1.
Default is FALSE.}

\item{show_peak}{Logical; if TRUE (default for single-basis HRFs), annotate
the peak time and amplitude on the plot.}

\item{...}{Additional arguments passed to underlying plot functions.}
}
\value{
Invisibly returns a data frame with the time and response values
  (useful for further customization).
}
\description{
Creates a visualization of an HRF object. For single-basis HRFs, shows the
response curve with peak annotation. For multi-basis HRFs (e.g., HRF_SPMG3),
shows all basis functions on the same plot.
}
\examples{
# Plot single-basis HRF
plot(HRF_SPMG1)

# Plot multi-basis HRF
plot(HRF_SPMG3)

# Plot with normalization
plot(HRF_GAMMA, normalize = TRUE)

# Custom time range
plot(HRF_SPMG1, time = seq(0, 30, by = 0.5))
}
