% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-preprocess-units.R
\name{preprocess_units}
\alias{preprocess_units}
\title{Preprocess the data for the DEGURBA spatial units classification}
\usage{
preprocess_units(
  units,
  classification,
  pop,
  resample_resolution = NULL,
  dissolve_units_by = NULL
)
}
\arguments{
\item{units}{character / object of class \code{sf}. Path to the vector layer with small spatial units, or an object of class \code{sf} with the small spatial units}

\item{classification}{character / SpatRaster. Path to the grid cell classification of the Degree of Urbanisation, or SpatRaster with the grid cell classification}

\item{pop}{character / SpatRaster. Path to the population grid, or SpatRaster with the population grid}

\item{resample_resolution}{numeric. Resolution to which the grids are resampled during pre-processing. If \code{NULL}, the grids are resampled to the smallest resolution among the population and classification grid.}

\item{dissolve_units_by}{character. If not \code{NULL}, the units are dissolved by this column's value, can for example be used to dissolve spatial units to a certain administrative level (see examples).}
}
\value{
named list with the required data to execute the spatial units classification procedure, and their metadata. The list contains the following elements:
\itemize{
\item \code{classification}: the (resampled and cropped) grid cell classification layer
\item \code{pop}: the (resampled and cropped) population grid
\item \code{units}: the (dissolved and filtered) spatial units (object of class \code{sf})
\item \code{metadata}: named list with the metadata of the input files. It contains the elements \code{units}, \code{classification} and \code{pop} (with paths to the respective data sources), \code{resample_resolution} and \code{dissolve_units_by} if not \code{NULL}. (Note that when the input sources are passed by object , the metadata might be empty).
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{preprocess_grid()} has been renamed to \code{DoU_preprocess_grid()} to create a more consistent API and to better indicate that this function is specifically designed for preprocessing the units data to reconstruct the DEGURBA classification with \code{DoU_classify_units()}.
}
\keyword{internal}
