% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{mfrr_em_price_last_activated_bid_RTD}
\alias{mfrr_em_price_last_activated_bid_RTD}
\title{Price of the last activated up-regulation bid - real time data}
\usage{
mfrr_em_price_last_activated_bid_RTD(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type €/MWh.
}
\description{
The price of the last activated up-regulation bid. The price is published real-time when Finland is a separate regulation area.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- mfrr_em_price_last_activated_bid_RTD(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/22
}
