% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fermicatsR.R
\docType{package}
\name{fermicatsR}
\alias{fermicatsR}
\alias{fermicatsR-package}
\title{fermicatsR (v 1.4): A package containing catalogs from the Fermi Large Area Telescope.}
\description{
Since its launch from the Kennedy Space Center on the 11th of June 2008, the Large Area Telescope (LAT, \url{https://www-glast.stanford.edu}), on board the Fermi Gamma-ray 
Space Telescope (formerly GLAST) has been performing an all-sky survey of the gamma-ray sky at energies between 20 MeV and 
300 GeV. The LAT Collaboration, consisting of more than 400 scientists at over 90 universities and laboratories in 12 countries, 
has produced a number of catalogs and lists of gamma-ray sources, at various phases of the mission. 
The fermicatsR package provides some of these catalogs in the form of the following data sets:
FGL0, FGL1, FGL2, FGL3, LAC3_LO, LAC3_HI, FHL1, FHL2, FIG1, and pulsars. For an application of the fermicatsR package, see Saz Parkinson et al., 
"Classification and Ranking of Fermi LAT Gamma-ray Sources from the 3FGL Catalog using Machine Learning Techniques", The Astrophysical Journal, \strong{820}, 8 (2016).
}
\section{fermicatsR }{

The following is a brief description of the data sets available within the fermicatsR package and their corresponding Fermi LAT catalogs/lists.

\itemize{
\item FGL0: Fermi LAT Bright Gamma-ray Source List, 205 gamma-ray sources, using 3 months of data [Abdo et al., ApJS, \strong{183}, 46 (2009)]
\item FGL1: Fermi LAT First Source Catalog, 1451 gamma-ray sources, using 11 months of data [Abdo et al., ApJS, \strong{188}, 405 (2010)]
\item FGL2: Fermi LAT Second Source Catalog, 1873 gamma-ray sources, using 24 months of data [Nolan et al., ApJS, \strong{199}, 31 (2012)]
\item FGL3: Fermi LAT Third Source Catalog, 3034 gamma-ray sources, using 48 months of data [Acero et al., ApJS, \strong{218}, 23 (2015)]
\item LAC3_LO: Fermi LAT Third Catalog of Active Galactic Nuclei - Low Galactic Latitude (|GLAT| < 10 deg.), 182 sources, using 48 months of data [Ackermann et al., ApJ, \strong{810}, 14 (2015)]
\item LAC3_HI: Fermi LAT Third Catalog of Active Galactic Nuclei - High Galactic Latitude (|GLAT| > 10 deg.), 1591 sources, using 48 months of data [Ackermann et al., ApJ, \strong{810}, 14 (2015)]
\item FHL1: First Fermi-LAT Catalog of Sources Above 10 GeV, 514 high-energy gamma-ray sources, using 36 months of data [Ackermann et al., ApJS, \strong{209}, 34 (2013)]
\item FHL2: The Second Catalog of Hard Fermi-LAT Sources,  360 gamma-ray sources, using 80 months of data [Ackermann et al., ApJS, \strong{222}, 5 (2016)]
\item FIG1: The First Fermi-LAT Inner Galaxy point source catalog, 48 gamma-ray sources, using 62 months of data [Ajello et al., ApJ, \strong{819}, 44 (2016)]
\item DF1: The First D3PO Fermi catalog of gamma-ray source candidates, 3106 sources, using 6.5 years of data [Selig et al., A\&A, \strong{581}, 126 (2015)]
\item pulsars: Fermi LAT List of Detected Pulsars [\url{https://confluence.slac.stanford.edu/x/5Jl6Bg}], 205 gamma-ray pulsars, last updated 2016-02-22
}

For more details on any of these data sets, type 'help(dataset)' or go to the Fermi Science Support Center (FSSC) web page (\url{http://fermi.gsfc.nasa.gov/ssc/data/access/}). 
You can also contact me directly with your questions.
}
\examples{
# Variability index vs Curvature significance of 2FGL sources, color-coded by source class
data(FGL2)
if (require("ggplot2")) {
qplot(log(Signif_Curve), log(Variability_Index), data = FGL2, color = CLASS1)
}
# Distribution of spindown luminosities of LAT-detected gamma-ray pulsars
data(pulsars)
hist(log10(pulsars$Edot), 
xlab = "Log(Spindown Luminosity) (erg/s)", 
ylab = "Number of pulsars", 
main = "LAT-Detected Gamma-ray Pulsars")
}
\author{
Pablo Saz Parkinson (\email{sazpark2@gmail.com})
}

