% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fauna_attributes.R
\name{fauna_attributes}
\alias{fauna_attributes}
\title{Get available attributes to filter species}
\usage{
fauna_attributes(data, attribute)
}
\arguments{
\item{data}{(data.frame) a data.frame imported with the
\code{\link{load_faunabr}} function or a data.frame generated with the
\code{\link{select_fauna}} function.}

\item{attribute}{(character) the type of characteristic. Accept more than one
option. See detail to see the options.}
}
\value{
a list of data.frames with the available options to use in the
\code{\link{select_fauna}} function.
}
\description{
This function displays all the options available to filter species by its
characteristics
}
\details{
The attribute argument accepts the following options: phylum, class, family,
genus, lifeForm, habitat, states, country, origin, and taxonomicstatus. These options
represent different characteristics of species that can be used for filtering.
}
\examples{
data("fauna_data") #Load data example
# Get available states, countries and lifeForms to filter species
d <- fauna_attributes(data = fauna_data,
                    attribute = c("country", "lifeform", "states"))
}
