% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_lse_coef}
\alias{qr_lse_coef}
\title{Compute least-squares coefficients using QR decomposition}
\usage{
qr_lse_coef(X, y)
}
\arguments{
\item{X}{numeric matrix of dimension \eqn{n \times p}.}

\item{y}{numeric response vector of length \eqn{n}.}
}
\value{
a numeric vector of regression coefficients.
}
\description{
Computes the coefficient vector \eqn{\hat\beta} solving the
least-squares problem \eqn{\min_\beta \|y - X\beta\|_2},
using a QR decomposition computed internally.
}
\details{
The QR decomposition of \eqn{X} is computed internally. The coefficients
are obtained by first computing \eqn{Q^\top y} and then solving the
resulting upper-triangular system involving the matrix \eqn{R}.
The orthogonal matrix \eqn{Q} is never formed explicitly.

This function is intended as a convenience wrapper for least-squares
estimation when the explicit QR factors are not required.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

coef1 <- fastQR::qr_lse_coef(X, y)

## reference computation
coef2 <- base::qr.coef(base::qr(X), y)

max(abs(coef1 - coef2))

}
