% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{ROC}
\alias{ROC}
\title{Receiver Operating Characteristic (ROC)}
\usage{
ROC(observed, predicted, n_thr = NULL)
}
\arguments{
\item{observed}{vector of binary outcomes.}

\item{predicted}{vector of predicted scores.}

\item{n_thr}{number of thresholds to use to construct the ROC curve. For
faster computations on large data, values below \code{length(predicted)-1}
can be used.}
}
\value{
A list with: \item{TPR}{True Positive Rate.} \item{FPR}{False
  Positive Rate.} \item{AUC}{Area Under the Curve.}
}
\description{
Computes the True and False Positive Rates (TPR and FPR, respectively) and
Area Under the Curve (AUC) by comparing the true (observed) and predicted
status using a range of thresholds on the predicted score.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
simul <- SimulateRegression(
  n = 500, pk = 20,
  family = "binomial", ev_xy = 0.8
)

# Logistic regression
fitted <- glm(simul$ydata ~ simul$xdata, family = "binomial")$fitted.values

# Constructing the ROC curve
roc <- ROC(predicted = fitted, observed = simul$ydata)
plot(roc)
}
}
\seealso{
Other goodness of fit functions: 
\code{\link{Concordance}()}
}
\concept{goodness of fit functions}
