% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factory.R
\name{build_factory}
\alias{build_factory}
\title{Easily Build Function Factories}
\usage{
build_factory(fun, ...)
}
\arguments{
\item{fun}{An anonymous function to turn into a factory.}

\item{...}{Arguments for the factory function. Things on the RHS will be
evaluated before building your factory unless explicitly quoted with
\code{quote}. See examples.}
}
\value{
A function factory.
}
\description{
Easily Build Function Factories
}
\examples{
y <- 2
power <- build_factory(
  fun = function(x) {
    x^exponent
  },
  exponent
)
square <- power(y)
square(2)
y <- 7
square(2)
}
