% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{body_replace}
\alias{body_replace}
\title{Replace Parts of a Function Body}
\usage{
body_replace(fn_body, target, replacement)
}
\arguments{
\item{fn_body}{The body of a function (as found via body(fun)).}

\item{target}{A quoted expression to replace.}

\item{replacement}{A quoted expression with which the target should be
replaced.}
}
\value{
A function body with the target replaced anywhere it occurs.
}
\description{
Replace quoted targets in the body of a function with quoted replacements.
}
\examples{
fun <- function(x) {
  x^exp
}
body_replace(body(fun), quote(exp), quote(!!exp))
}
