% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portmanteau_tests.R
\name{portmanteau_tests}
\alias{portmanteau_tests}
\title{Functional Hypothesis Tests for Functional Data}
\usage{
portmanteau_tests(
  X,
  test = c("variety", "single", "multi", "spectral", "independence", "imhof"),
  lag = 5,
  M = 1000,
  method = c("iid", "bootstrap"),
  kernel = bartlett_kernel,
  block_size = NULL,
  bandwidth = NULL,
  components = 3,
  resample_blocks = "separate",
  replace = FALSE,
  alpha = 0.05
)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{test}{A String specifying the hypothesis test. Currently available
tests are: 'variety', 'single-lag', 'multi-lag', 'spectral', 'independence',
and 'imhof'.}

\item{lag}{A positive integer to specify the lag, or maximum lag, of
interest. Only used for the "single-lag", "multi-lag", "independence", and
"imhof" tests.}

\item{M}{Numeric to specify the number of Monte-Carlo or resampled
simulations to use for the limiting distributions.}

\item{method}{String indicating the method for the \code{single} test,
options include:
\itemize{
\item \strong{iid}: The
hypothesis test will use a strong-white noise assumption (instead of a
weak-white noise assumption).
\item \strong{resample}: The hypothesis
test is evaluated by approximating the limiting distribution of the test
statistic via a (block) resampling process.
}
Additional methods are forthcoming.}

\item{kernel}{Kernel function for spectral test or estimation of covariance.}

\item{block_size}{Numeric to specify block size for resampling tests.}

\item{bandwidth}{Numeric for bandwidth of covariance estimation. If left null,
with be defined by \eqn{N^{1 / (2 * \text{KO} + 1)}} where KO is the order
of the selected kernel.}

\item{components}{Number of functional principal components to use in the
independence test.}

\item{resample_blocks}{String indicating the type of resample test to use.
Using \code{separate} gives blocks which are separate while \code{overlapping}
creates overlapping or sliding windows. When \code{blocksize=1} then these
will be identical.}

\item{replace}{Boolean for using a permutation or bootstrapped statistic when
\code{method='resample'}.}

\item{alpha}{Numeric value for significance in [0,1].}
}
\value{
List with results dependent on the test. In general, returns the pvalue,
statistic, and simulations/quantile.
}
\description{
Computes a variety of portmanteau hypothesis tests for functional data in the
form of dfts objects.
}
\details{
The "single"-lag portmanteau test assesses the significance of
empirical lagged autocovariance operators at a single lag \code{lag}.
It tests the null hypothesis that the lag-h autocovariance operator is equal
to 0. The test is designed for stationary functional time-series, and is
valid under conditional heteroscedasticity conditions.

The "multi"-lag portmanteau test assesses the cumulative significance of
empirical lagged autocovariance operators, up to a user-selected maximum lag
\code{lag}. It tests the null hypothesis that the first lag-h autocovariance
operators, \eqn{h=1,\dots,lag}, is equal to 0. The test is designed for
stationary functional time-series, and is valid under conditional
heteroscedasticity conditions.

The "spectral" portmanteau test measures the proximity of a functional time
series to a white noise. Comparison is made to the constant spectral
density operator of an uncorrelated series. The test is not for general
white noise series, and may not hold under functional conditionally
heteroscedastic assumptions.

The "independence" portmanteau test measures independence and identical
distribution based lagged cross-variances from dimension reduction using
functional principal components analysis. The test is not for general white
noise series, and may not hold under functional conditionally
heteroscedastic assumptions.

The "imhof" portmanteau test is an analogue of the "single-lag" test. While
the "single-lag" test computes the limiting distribution of the test
statistic via a Welch-Satterthwaite approximation, the "imhof" test directly
computes the coefficients of the quadratic form in normal variables. Hence,
the test is computationally expensive.
}
\examples{
b <- generate_brownian_motion(100)
res0 <- portmanteau_tests(b, test = "single", lag = 2, M=50)
res1 <- portmanteau_tests(b, test = "multi", lag = 2, alpha = 0.01)
res2 <- portmanteau_tests(b,
  test = "spectral", alpha = 0.1,
  kernel = parzen_kernel,
  bandwidth = adaptive_bandwidth(b, kernel = parzen_kernel)
)
res3 <- portmanteau_tests(b, test = "independence", components = 2, lag = 2)
}
\references{
Kim, M., Kokoszka P., & Rice G. (2023) White noise testing for
functional time series. Statist. Surv., 17, 119-168, DOI: 10.1214/23-SS143

Characiejus, V., & Rice, G. (2020). A general white noise test
based on kernel lag-window estimates of the spectral density operator.
Econometrics and Statistics, 13, 175–196.

Kokoszka P., & Rice G., & Shang H.L. (2017). Inference for the
autocovariance of a functional time series under conditional
heteroscedasticity. Journal of Multivariate Analysis, 162, 32-50.

Zhang X. (2016). White noise testing and model diagnostic
checking for functional time series. Journal of Econometrics, 194, 76-95.

Gabrys R., & Kokoszka P. (2007). Portmanteau Test of Independence
for Functional Observations. Journal of the American Statistical Association,
102:480, 1338-1348, DOI: 10.1198/016214507000001111.

Chen W.W. & Deo R.S. (2004). Power transformations to induce
normality and their applications. Journal of the Royal Statistical Society:
Series B (Statistical Methodology), 66, 117-130.
}
