% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_testMultipleControl.R
\name{testMultipleControl}
\alias{testMultipleControl}
\title{Multiple Comparison Statistical Test (Friedman + Control Holm PostHoc)}
\usage{
testMultipleControl(e, output, rankOrder = "max", alpha = 0.05)
}
\arguments{
\item{e}{Input experiment}

\item{output}{The output for which the tet will be performed.}

\item{rankOrder}{The optimization strategy, can be either maximizing "max"
or minimizing "min" the target output variable.}

\item{alpha}{The significance level used for the whole testing procedure.}
}
\value{
an testMultipleControl object
}
\description{
This function perfoms a multiple comparison statistical test for the given
experiment. First of all it performs a Friedman Test over all methods. In the
case this test is rejected, meaning that significant differences are present
among the methods a post-hoc test is then executed. For that, a comparison
using the best method as a control is performed for each other method,
finally a Holm familywise error correction is applied to the resulting
p-values.
}
\examples{
# First we create an experiment from the wekaExperiment problem and prepare
# it to apply the test:
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
experiment <- expReduce(experiment, "fold", mean)
experiment <- expSubset(experiment, list(featureSelection = "yes"))
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Then we perform a testMultiplePairwise test procedure
test <- testMultipleControl(experiment, "accuracy", "max")

summary(test)
}

