% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_plotExpSummary.R
\name{plotExpSummary}
\alias{plotExpSummary}
\title{Barplot for summarizing an experiment output variable}
\usage{
plotExpSummary(exp, output, columns = 0, freeScale = FALSE,
  fun = identity, grayscale = FALSE)
}
\arguments{
\item{exp}{- The experiment object to take the data from}

\item{output}{- A string identifying the name of the output variable to be
plotted}

\item{columns}{- Integer number, 0 for a wide aspect plot and any other value
to include n columns of facets separating the problems.}

\item{freeScale}{- Boolean, if using facets sets the scale of each one
independent or not}

\item{fun}{- A function to be applied to the selected output variables before
being plotted.}

\item{grayscale}{- Defaulted to False. True for a plot in grayscale.}
}
\value{
an exPlot object
}
\description{
This function builds a barplot for a given experiment output variable,
summarizing its distribution according to the different methods and problems.
The aspect of the plot can be parametrized in several ways.
}
\details{
Please notice that the plot function requires that an unique configuration
of parameters is present in the experiment. So the user must have processed and
instantiated the experiment before.
}
\examples{
# This example plots the distribution of the trainingTime variable in the
# wekaExperiment problem.

# First we create the experiment from the problem.
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")

# Next we must process it to have an unique parameter configuration:
# We select a value for the parameter featureSelection:
experiment <- expSubset(experiment, list(featureSelection = "yes"))
# Then we reduce the fold parameter:
experiment <- expReduce(experiment, "fold", mean)
# Finally we remove unary parameters by instantiation:
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Now we can generate several plots:

# Default plot:
plotExpSummary(experiment, "accuracy")

# We can include faceting in the plot by dividing it into columns:
plotExpSummary(experiment, "accuracy", columns=3)

# If we want to show the independent interaction for the output variable
# in each experiment we can make the scales for example, remark the difference
# in :
plotExpSummary(experiment, "trainingTime", columns=3, freeScale=FALSE)
plotExpSummary(experiment, "trainingTime", columns=3, freeScale=TRUE)
}

