% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_plotCumulativeRank.R
\name{plotCumulativeRank}
\alias{plotCumulativeRank}
\title{Area plot for the rank distribution from a multiple test}
\usage{
plotCumulativeRank(testMultiple, grayscale = FALSE)
}
\arguments{
\item{testMultiple}{Statistical test from which the plot is generated. The
rankings are obtained from the Friedman test.}

\item{grayscale}{Configure the plot using a grayscale palette.}
}
\value{
an exPlot object
}
\description{
This function builds an area plot from a testMultiple object displaying the
cumulative value for each method for all the evaluated problems. The value
for the rankings is obtained from the Friedman test independently of the scope
of the test (control or pairwise).
}
\examples{
# First we create an experiment from the wekaExperiment problem and prepare
# it to apply the test:
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
experiment <- expReduce(experiment, "fold", mean)
experiment <- expSubset(experiment, list(featureSelection = "no"))
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Then we perform a Friedman test included ina a testMultipleControl
# test procedure
test <- testMultipleControl(experiment, "accuracy")

# Finally we obtain the plot
plotCumulativeRank(test)
cat()
}

