% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expInstantiate.R
\name{expInstantiate}
\alias{expInstantiate}
\title{Instatiate the methods in the experiment for each one of the different
parameter configurations.}
\usage{
expInstantiate(e, parameters = NULL, removeUnary = TRUE)
}
\arguments{
\item{e}{The experiment object to be instantiated}

\item{parameters}{A vector indicating the parameters to be instantiaded.
If NULL or default all parameters would be considered.}

\item{removeUnary}{Boolean value indicating if the unary parameters will be
used in an instantiation or if the column can be erased.}
}
\value{
an experiment object
}
\description{
When performing statistical tests or summarizing an experiment for a given
output variable there can be different parameter configuration for each
interaction of method and problem. Once applied the desired transformations
this function can be used to remove unary parameters from the experiment or to
instantiate the methods for each configuration.
}
\details{
If any method is instantiated the cartesian product of the method and the
selected parameters is performed and included in the resulting experiment as
the methods variable. The name of the corresponding value will indicate the
name of the former method and the value of each parameter instantiated.
}
\examples{
# Create an experiment from the wekaExperiment
experiment <- expCreate(wekaExperiment, name="test-exp", parameter="fold")

# We would like to reduce the fold parameter by its mean value. It becomes an
# unary parameter.
experiment <- expReduce(experiment, "fold", mean)

# Now we instantiate the experiment by the featureSelection parameter and
# remove the unary fold parameter
expInstantiate(experiment, removeUnary=TRUE)
}

