% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expirest_osle.R
\name{plot_expirest_osle}
\alias{plot_expirest_osle}
\title{Illustrating the ordinary shelf life estimate (osle)}
\usage{
plot_expirest_osle(
  model,
  show_grouping = "yes",
  response_vbl_unit = NULL,
  x_range = NULL,
  y_range = NULL,
  mtbs = "verified",
  plot_option = "full",
  ci_app = "line"
)
}
\arguments{
\item{model}{An \sQuote{\code{expirest_osle}} object, i.e. a list returned
by the \code{\link{expirest_osle}()} function.}

\item{show_grouping}{`r lifecycle::badge("deprecated")`
`show_grouping = \"yes\" or \"no\"` is no longer supported. Use the
\code{mtbs} parameter instead which allows choosing a specific model,
i.e. also the \emph{common intercept / common slope case} model which
was the default model when \code{show_grouping} was \code{"no"}.}

\item{response_vbl_unit}{A character string that specifies the unit
associated with the response variable. The default is \code{NULL}.}

\item{x_range}{A numeric vector of the form \code{c(min, max)} that
specifies the range of the time variable to be plotted. The default is
\code{NULL} and the \eqn{x} range is calculated automatically on the basis
of the estimated shelf life.}

\item{y_range}{A numeric vector of the form \code{c(min, max)} that
specifies the range of the response variable to be plotted. The default
is \code{NULL} and the \eqn{y} range is calculated automatically on the
basis of the time course of the response.}

\item{mtbs}{A character string that specifies the \dQuote{model to be shown},
i.e. either \code{verified}, which is the default, or one of \code{cics},
\code{dics}, \code{dids} or \code{dids.pmse}. The \code{verified} model
is the model that was identified through the poolability check. It is
thus also one of the possible optional models. The \code{dids} model
represents the case where a separate model is fitted to the data of each
individual batch while the \code{dids.pmse} model is the interaction
model which includes the \eqn{batch} variable as main effect and in the
interaction term with the \eqn{time} variable (\eqn{batch \times time}),
i.e. a model where the mean square error is pooled across batches.}

\item{plot_option}{A character string of either \code{"full"} or
\code{"lean"} that specifies if additional information should be put out
on the plot (option \code{"full"}) or only basic information (option
\code{"lean"}), i.e. the data points, the fitted regression line with
the confidence interval, the specification limit(s) and the estimated
shelf life limit(s). The default is \code{"full"}.}

\item{ci_app}{A character string of either \code{"line"} or \code{"ribbon"},
that specifies the appearance of the confidence interval, i.e. if the
limits should be plotted as lines (option \code{"line"}) or as a shaded
ribbon (option \code{"ribbon"}). The default is \code{"line"}.}
}
\value{
An object of class \sQuote{\code{plot_expirest_osle}} is returned
invisibly consisting of the following elements:
\item{Model}{The \sQuote{\code{expirest_osle}} object that was passed via
  the \code{model} argument.}
\item{Expiry}{A data frame of type \code{expiry}.}
\item{Graph}{A \sQuote{\code{ggplot2}} object for the graphical display.}
\item{Prediction}{A data frame of the predicted values.}
\item{text}{A data frame of the text elements on the plot.}
\item{hlines}{A data frame of the horizontal line elements on the plot.}
\item{vlines}{A data frame of the vertical line elements on the plot.}
}
\description{
The function \code{plot_expirest_osle()} makes a graphical display of the
shelf life estimate done by the \code{\link{expirest_osle}()} function.
}
\details{
The function \code{plot_expirest_osle()} uses the data and the
information about the linear model that was used for the estimation of
the shelf life by aid of the \code{\link{expirest_osle}()} function. It
plots a graph of the time course of a parameter, a linear regression line
fitted to the data and the associated confidence or prediction interval.
In addition, it shows features of the shelf life estimation.

For plotting, the \code{\link[ggplot2]{ggplot}()} function from the
\sQuote{\code{ggplot2}} package is used. The various arguments can be
used to control the appearance of the plot. The \sQuote{\code{ggplot2}}
object of the generated plot is contained in the \code{Graph} element of
the list that is returned by \code{\link{plot_expirest_osle}()} and can be
used to modify the appearance of the graph.
}
\examples{
# Start by making an "ordinary shelf life estimation" (osle).
res1 <-
  expirest_osle(data = exp1[exp1$Batch \%in\% c("b2", "b5", "b7"), ],
                response_vbl = "Potency", time_vbl = "Month",
                batch_vbl = "Batch", sl = 95, sl_sf = 3,
                srch_range = c(0, 500), sf_option = "loose")

# Pass the 'expirest_osle' object on to the plot_expirest_osle() function.
# This function does not produce any output. It returns a 'plot_expirest_osle'
# object that is essentially an 'expirest_osle' object augmented by a 'ggplot'
# object.
gg1 <- plot_expirest_osle(
  model = res1, response_vbl_unit = "\%", x_range = NULL, y_range = c(93, 105),
  mtbs = "verified", plot_option = "full", ci_app = "line")
\dontrun{
  gg1

  # Since the element gg1$Graph is a 'ggplot' object it can be used for further
  # manipulation by aid of 'ggplot2' functions.
  if (requireNamespace("ggplot2")) {
    library(ggplot2)

    gg1$Graph + labs(title = "Ordinary Shelf Life Estimation (OSLE)",
                     x = "Time [months]", y = "Potency [\% LC]") +
      scale_x_continuous(limits = c(-1, 31), breaks = seq(0, 30, 6))
  }
}

# Repeat this for a different intercept / different slope (dids) model.
res2 <-
  expirest_osle(data = exp1[exp1$Batch \%in\% c("b4", "b5", "b8"), ],
                response_vbl = "Potency", time_vbl = "Month",
                batch_vbl = "Batch", sl = 95, sl_sf = 3,
                srch_range = c(0, 500), sf_option = "loose")

gg2 <- plot_expirest_osle(
  model = res2, response_vbl_unit = "\%", x_range = c(0, 43),
  y_range = c(83, 107), mtbs = "verified", plot_option = "full",
  ci_app = "ribbon")
\dontrun{
  gg2
}

# In case of different intercept / different slope models, individually fit
# linear models are shown by default, i.e. with the 'mtbs' parameter set
# as "verified". To get the different intercept / different slope model
# displayed where the mean square error is pooled across batches, i.e. the
# dids.pmse model, the 'mtbs' parameter has to be set accordingly.

gg3 <- plot_expirest_osle(
  model = res2, response_vbl_unit = "\%", x_range = c(0, 43),
  y_range = c(83, 107), mtbs = "dids.pmse", plot_option = "full",
  ci_app = "ribbon")
\dontrun{
  gg3
}
}
\seealso{
\code{\link{expirest_osle}}, \code{\link{expirest_wisle}},
\code{\link{plot_expirest_wisle}}.
}
