% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneGenHWSim.R
\name{OneGenHWSim}
\alias{OneGenHWSim}
\title{Simulating one generation of genotypes under Hardy-Weinberg equilibrium}
\usage{
OneGenHWSim(n.ind = 50, p = 0.5, n.sim = 100)
}
\arguments{
\item{n.ind}{Integer indicating the census size of the simulated populations.
If decimals are inserted, they will be rounded.}

\item{p}{Numerical between zero and one that indicates A1's allele
frequency. A2's allele frequency is assumed to be \code{1-p}.}

\item{n.sim}{Number of simulations to be made. If decimals are inserted,
they will be rounded.}
}
\value{
A \code{data.frame} containing the number of individuals for each
genotype.
}
\description{
\code{OneGenHWSim} creates \code{n.sim} simulations of one
generation of genotypes under Hardy-Weinberg equilibrium for a
bi-allelic loci.
}
\examples{

#using the default values (n.ind = 50, p = 0.5, n.sim = 100):
OneGenHWSim()

#Simulating with a already fixed allele:
OneGenHWSim(n.ind = 50, p = 1)

# Testing if the simulation works:
A1freq <- .789 #any value could work
n.simul <- 100
simulations <- OneGenHWSim(n.ind = n.simul, n.sim = n.simul, p = A1freq)

#expected:
c(A1freq^2, 2*A1freq*(1-A1freq), (1-A1freq)^2)

#simulated:
apply(X = simulations, MARGIN = 2, FUN = function(x){mean(x)/n.simul})

}
\references{
Hardy, G. H. (1908). Mendelian proportions in a mixed
population. Science, 28, 49–50.

Weinberg, W. (1908). Uber den Nachweis der Vererbung beim Menschen.
Jahreshefte des Vereins fur vaterlandische Naturkunde in Wurttemberg,
Stuttgart 64:369–382. [On the demonstration of inheritance in humans].
Translation by R. A. Jameson printed in D. L. Jameson (Ed.), (1977).
Benchmark papers in genetics, Volume 8: Evolutionary genetics (pp.
115–125). Stroudsburg, PA: Dowden, Hutchinson & Ross.

Mayo, O. (2008). A century of Hardy–Weinberg equilibrium. Twin Research
and Human Genetics, 11(3), 249-256.
}
\author{
Matheus Januario, Dan Rabosky, Jennifer Auler
}
