% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edd_sim.R
\name{edd_sim}
\alias{edd_sim}
\title{Simulate a phylogenetic tree using the eve model}
\usage{
edd_sim(
  pars,
  age,
  metric = "ed",
  offset = "none",
  size_limit = 10000,
  retry = 100
)
}
\arguments{
\item{pars}{A numeric vector of 6 parameters for the simulation:
\describe{
\item{\code{lambda_0}}{Intrinsic speciation rate (must be positive and larger than \code{mu_0}).}
\item{\code{mu_0}}{Intrinsic extinction rate.}
\item{\code{beta_N}}{Effect size of species richness on the speciation rate (can be any sign or zero).}
\item{\code{beta_phi}}{Effect size of evolutionary relatedness on the speciation rate (can be any sign or zero).}
\item{\code{gamma_N}}{Effect size of species richness on the extinction rate (can be any sign or zero).}
\item{\code{gamma_phi}}{Effect size of evolutionary relatedness on the extinction rate (can be any sign or zero).}
}}

\item{age}{A numeric value representing the maximum crown age at which the simulation will stop.}

\item{metric}{A character string indicating the evolutionary relatedness measure to be used in the simulation.
Options are:
\describe{
\item{\code{"pd"}}{Phylogenetic diversity as the evolutionary relatedness measure (a community-wise constraint on diversification).}
\item{\code{"ed"}}{Evolutionary distinctiveness as a lineage-specific measure.}
\item{\code{"nnd"}}{Phylogenetic distance to the nearest neighbor as a lineage-specific measure.}
}}

\item{offset}{A character string specifying the method for applying an offset. Currently, only \code{"simtime"} is available,
and it can only be used when \code{metric} is set to \code{"pd"}. Defaults to \code{"none"}.}

\item{size_limit}{An integer specifying the maximum size of the simulation result. Defaults to \code{10000}.}

\item{retry}{An integer specifying the number of retry attempts in case of failure. Defaults to \code{100}.}
}
\value{
A list containing the following components:
\describe{
\item{tes}{A phylogeny with only extant lineages, or \code{NULL} if the simulation failed after all retry attempts.}
\item{tas}{A phylogeny with all lineages, or \code{NULL} if the simulation failed after all retry attempts.}
\item{L}{An L table recording the historical events, or \code{NULL} if the simulation failed after all retry attempts.}
\item{msg}{A character string containing error messages (if any) accumulated over the retry attempts.}
}
}
\description{
The \code{edd_sim} function simulates evolutionary relatedness dependent phylogenies based on the specified parameters, given a fixed crown age.
It provides functionality to retry the simulation multiple times in case of errors, with an optional limit on the size of the result.
}
\details{
The function simulates evolutionary relatedness dependent diversification based on a specified set of parameters (\code{pars}). The intrinsic
speciation rate (\code{lambda_0}) must be positive and greater than the intrinsic extinction rate (\code{mu_0}). The
remaining parameters, which account for the effects of species richness and evolutionary relatedness on diversification
rates, can be of any sign or zero. The simulation may be retried multiple times (up to the specified \code{retry} limit)
if failures occur during execution.

The \code{metric} argument allows for different ways of measuring evolutionary relatedness, with three options: phylogenetic
diversity (\code{"pd"}), evolutionary distinctiveness (\code{"ed"}), and nearest neighbor distance (\code{"nnd"}). When using
the phylogenetic diversity metric, an optional offset method (\code{"simtime"}) is available. The simulation will terminate
once the specified \code{age} is reached or the \code{size_limit} is exceeded.
}
\examples{
# Example of simulation and plotting
# optionally set the number of threads.
# defaults to number of logical cores.
# RcppParallel::setThreadOptions(numThreads = 1)

pars = c(0.5, 0.1, -0.001, -0.001, 0.0, 0.0)
sim <- edd_sim(pars = pars, age = 10, metric = "nnd", offset = "none")

}
\references{
Impact of Evolutionary Relatedness on Species Diversification: A New Birth-Death Model
Tianjian Qin, Luis Valente, Rampal S. Etienne
Journal of Theoretical Biology; DOI: https://doi.org/10.1016/j.jtbi.2024.111992
}
