% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{inst_pkg}
\alias{inst_pkg}
\title{Install R Packages from Multiple Sources}
\usage{
inst_pkg(
  pkg = NULL,
  source = c("CRAN", "GitHub", "Bioconductor", "Local"),
  path = NULL,
  ...
)
}
\arguments{
\item{pkg}{Character vector. Package name(s) or GitHub repo (e.g., "user/repo").
Not required for \code{source = "local"}.}

\item{source}{Character. Package source: "CRAN", "GitHub", "Bioconductor", "Local".
Case-insensitive, first match used.}

\item{path}{Character. Path to local package file (required when \code{source = "local"}).}

\item{...}{Additional arguments passed to \code{\link[utils]{install.packages}},
\code{\link[devtools]{install_github}}, or \code{\link[BiocManager]{install}}.}
}
\value{
NULL (invisibly). Side effect: installs packages.
}
\description{
Install R packages from CRAN, GitHub, Bioconductor, or local source.
Automatically respects mirror settings from \code{set_mirror()}.
}
\examples{
\dontrun{
# Install from CRAN:
inst_pkg("dplyr", source = "CRAN")

# Install from GitHub:
inst_pkg("hadley/emo", source = "GitHub")

# Install from Bioconductor:
inst_pkg("scRNAseq", source = "Bioconductor")

# Install from local file:
inst_pkg(source = "Local", path = "mypackage.tar.gz")
}

}
