% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_execute.R
\name{safe_execute}
\alias{safe_execute}
\title{Safely Execute an Expression}
\usage{
safe_execute(expr, fail_message = "An error occurred", quiet = FALSE)
}
\arguments{
\item{expr}{Code to evaluate.}

\item{fail_message}{Message to display if an error occurs. Default: "An error occurred".}

\item{quiet}{Logical. If \code{TRUE}, suppress messages. Default: \code{FALSE}.}
}
\value{
The result of the expression if successful; otherwise \code{NULL}.
}
\description{
Evaluate code with unified error handling (and consistent warning reporting).
On error, prints a CLI message (unless \code{quiet = TRUE}) and returns \code{NULL}.
}
\examples{
safe_execute(log(1))
safe_execute(log("a"), fail_message = "Failed to compute log")
}
