% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-game-box-score.R
\name{getGameBoxScore}
\alias{getGameBoxScore}
\title{Get game box-score}
\usage{
getGameBoxScore(season_code, game_code)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{game_code}{One or more game codes as obtained from \code{\link[=getCompetitionGames]{getCompetitionGames()}}.}
}
\value{
Returns a list of elements for the chosen games and seasons
\itemize{
\item \strong{Team}. Name of the teams
\item \strong{Coach}. Name of the coaches
\item \strong{EndOfQuarter}. Team accumulated points by quarter
\item \strong{ByQuarter}. Team points for each quarter
\item \strong{PlayerStats}. Statistics for each player in the game
\item \strong{TeamStats}. Aggregated statistics for each team in the game
}

Glossary of columns:\tabular{ll}{
   \strong{Column name} \tab \strong{Column extended name} \cr
   GP \tab Game player \cr
   GS \tab Game started \cr
   MIN \tab Minutes played \cr
   PTS \tab Points scored \cr
   2PM \tab Two-pointers made \cr
   2PA \tab Two-pointers attempted \cr
   2P\% \tab Two-point \% \cr
   3PM \tab Three-pointers made \cr
   3PA \tab Three-pointers attempted \cr
   3P\% \tab Three-point \% \cr
   FTM \tab Free throws made \cr
   FTA \tab Free throws attempted \cr
   FT\% \tab Free-throw \% \cr
   OREB \tab Offensive rebounds \cr
   DREB \tab Defensive rebounds \cr
   TREB \tab Total rebounds \cr
   AST \tab Assists \cr
   STL \tab Steals \cr
   TO \tab Turnovers \cr
   BLK \tab Blocks \cr
   BLKA \tab Blocks against \cr
   FC \tab Personal fouls committed \cr
   FD \tab Personal fouls drawn \cr
   PIR \tab Performance Index Rating \cr
}


Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/game-center/2023-24/crvena-zvezda-meridianbet-belgrade-ldlc-asvel-villeurbanne/E2023/1/#boxscore}{BoxScore}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

getGameBoxScore(season_code = c("E2023", "U2023"), game_code = 1)

}

}
