% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-competition-standings.R
\name{getCompetitionStandings}
\alias{getCompetitionStandings}
\title{Get competition traditional standings}
\usage{
getCompetitionStandings(season_code, round)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{round}{One or more round codes as obtained from \code{\link[=getCompetitionRounds]{getCompetitionRounds()}}.}
}
\value{
Returns a summary tibble of standings for chosen competitions and rounds

Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/standings/?season=2023-24&type=Traditional&phase=REGULAR\%20SEASON}{Traditional standings}
}
\description{
Get competition traditional standings
}
\examples{

\dontrun{

getCompetitionStandings(season_code = c("E2023", "E2022"), round = 1)

}

}
\keyword{`r}
\keyword{competitionStandings}
\keyword{lifecycle::badge('experimental')`}
