% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_lasso.R
\name{simLASSO}
\alias{simLASSO}
\title{Compute Lasso Estimator for simulated Data}
\usage{
simLASSO(lambda, X, beta, sigma, penalize, rescale.lambda = TRUE, ind = 1)
}
\arguments{
\item{lambda}{Penalty factor to be applied}

\item{X}{Design matrix of regression problem}

\item{beta}{true value of parameter vector to simulate from}

\item{sigma}{true value of square root of variance parameter for simulating.}

\item{penalize}{Vector giving penalty structure. Supplied to glmnet as `\code{penalty.factor}'. By default, all coefficients except first are penalized.}

\item{rescale.lambda}{Should lambda be rescaled to account for the 
default re-scaling done by glmnet?}

\item{ind}{Index of coefficient to be returned.  Value of 0 implies
all coefficients (i.e. the full parameter vector estimate)}
}
\description{
Simulates data from a regression model
	and computes the lasso estimate for this data.
}
\details{
Simulates data from a regression model with true
	coefficient parameter \code{beta} and normal errors with
	standard deviation \code{sigma}.  Computes the LASSO
	estimate for the coefficient vector using the \code{glmnet}
	function from the package of the same name.
}
\author{
Kayleigh Keller
}
