% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_r.R
\name{estimate_r}
\alias{estimate_r}
\title{Estimates the linear correlation (Pearson's r) between two continuous
variables}
\usage{
estimate_r(
  data = NULL,
  x = NULL,
  y = NULL,
  r = NULL,
  n = NULL,
  x_variable_name = "My x variable",
  y_variable_name = "My y variable",
  conf_level = 0.95,
  save_raw_data = TRUE
)
}
\arguments{
\item{data}{For raw data - A data frame or tibble}

\item{x}{For raw data - The column name of the outcome
variable, or a vector of numeric data}

\item{y}{For raw data - The column name of the outcome
variable, or a vector of numeric data}

\item{r}{For summary data - A pearson's r correlation coefficient}

\item{n}{For summary data - Sample size, an integer > 0}

\item{x_variable_name}{Optional friendly name for the x variable.
Defaults to 'My x variable' or the outcome variable column name if a
data frame is passed.}

\item{y_variable_name}{Optional friendly name for the y variable.
Defaults to 'My y variable' or the outcome variable column name if a
data frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{save_raw_data}{For raw data; defaults to TRUE; set to FALSE to save
memory by not returning raw data in estimate object}
}
\value{
Returns object of class esci_estimate
\itemize{
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{mean} -
\item \emph{mean_LL} -
\item \emph{mean_UL} -
\item \emph{median} -
\item \emph{median_LL} -
\item \emph{median_UL} -
\item \emph{sd} -
\item \emph{min} -
\item \emph{max} -
\item \emph{q1} -
\item \emph{q3} -
\item \emph{n} -
\item \emph{missing} -
\item \emph{df} -
\item \emph{mean_SE} -
\item \emph{median_SE} -
}
\item \strong{es_r}
\itemize{
\item \emph{x_variable_name} -
\item \emph{y_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{n} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{regression}
\itemize{
\item \emph{component} -
\item \emph{values} -
\item \emph{LL} -
\item \emph{UL} -
}
\item \strong{raw_data}
\itemize{
\item \emph{x} -
\item \emph{y} -
\item \emph{fit} -
\item \emph{lwr} -
\item \emph{upr} -
}
}
}
\description{
\code{estimate_r} is suitable for a design with two continuous
variables.  It estimates the linear correlation between two variables
(Pearson's r) with a confidence interval.  You can pass raw data or
summary data.
}
\details{
Reach for this function to conduct simple linear correlation or simple
linear regression.

Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_correlation]{plot_correlation()}} and you can test hypotheses with
\code{\link[=test_correlation]{test_correlation()}}.  In addition, you can use \code{\link[=plot_scatter]{plot_scatter()}}
to visualize the raw data and to conduct a regression analysis that r
returns predicted Y' values from a given X value.

The estimated correlation is from \code{\link[statpsych:ci.cor]{statpsych::ci.cor()}}, which uses the
Fisher r-to-z approach.
}
\examples{
# From raw data
data("data_thomason_1")

estimate_from_raw <- esci::estimate_r(
  esci::data_thomason_1,
  Pretest,
  Posttest
)

# To visualize the value of r
myplot_correlation <- esci::plot_correlation(estimate_from_raw)

# To visualize the data (scatterplot) and use regression to obtain Y' from X
myplot_scatter_from_raw <- esci::plot_scatter(estimate_from_raw, predict_from_x = 10)

# To evaluate a hypothesis (interval null from -0.1 to 0.1):
res_htest_from_raw <- esci::test_correlation(
  estimate_from_raw,
  rope = c(-0.1, 0.1)
)


# From summary data
estimate_from_summary <- esci::estimate_r(r = 0.536, n = 50)

# To visualize the value of r
myplot_correlation_from_summary <- esci::plot_correlation(estimate_from_summary)

# To evaluate a hypothesis (interval null from -0.1 to 0.1):
res_htest_from_summary <- esci::test_correlation(
  estimate_from_summary,
  rope = c(-0.1, 0.1)
)


}
