% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_connorm.r
\name{ci_connorm}
\alias{ci_connorm}
\title{ci_connorm .}
\usage{
ci_connorm(y, A, b, eta, Sigma = NULL, p = c(level/2, 1 - (level/2)),
  level = 0.05, Sigma_eta = Sigma \%*\% eta)
}
\arguments{
\item{y}{an \eqn{n} vector, assumed multivariate normal with mean \eqn{\mu}
and covariance \eqn{\Sigma}.}

\item{A}{an \eqn{k \times n} matrix of constraints.}

\item{b}{a \eqn{k} vector of inequality limits.}

\item{eta}{an \eqn{n} vector of the test contrast, \eqn{\eta}.}

\item{Sigma}{an \eqn{n \times n} matrix of the population covariance, \eqn{\Sigma}.
Not needed if \code{Sigma_eta} is given.}

\item{p}{a vector of probabilities for which we return
equivalent \eqn{\eta^{\top}\mu}.}

\item{level}{if \code{p} is not given, we set it by default to
\code{c(level/2,1-level/2)}.}

\item{Sigma_eta}{an \eqn{n} vector of \eqn{\Sigma \eta}.}
}
\value{
The values of \eqn{\eta^{\top}\mu} which have the corresponding
CDF.
}
\description{
Confidence intervals on normal mean, subject to linear constraints.
}
\details{
Inverts the constrained normal inference procedure described
by Lee \emph{et al.}

Let \eqn{y} be multivariate normal with unknown mean \eqn{\mu}
and known covariance \eqn{\Sigma}. Conditional on \eqn{Ay \le b}{Ay <= b}
for conformable matrix \eqn{A} and vector \eqn{b}, and given
constrast vector \eqn{eta} and level \eqn{p}, we compute
\eqn{\eta^{\top}\mu} such that the cumulative distribution of
\eqn{\eta^{\top}y} equals \eqn{p}.
}
\note{
An error will be thrown if we do not observe \eqn{A y \le b}{A y <= b}.
}
\examples{
set.seed(1234)
n <- 10
y <- rnorm(n)
A <- matrix(rnorm(n*(n-3)),ncol=n)
b <- A\%*\%y + runif(nrow(A))
Sigma <- diag(runif(n))
mu <- rnorm(n)
eta <- rnorm(n)

pval <- pconnorm(y=y,A=A,b=b,eta=eta,mu=mu,Sigma=Sigma)
cival <- ci_connorm(y=y,A=A,b=b,eta=eta,Sigma=Sigma,p=pval)
stopifnot(abs(cival - sum(eta*mu)) < 1e-4)

}
\references{
Lee, J. D., Sun, D. L., Sun, Y. and Taylor, J. E. "Exact post-selection inference, 
with application to the Lasso." Ann. Statist. 44, no. 3 (2016): 907-927.
doi:10.1214/15-AOS1371. \url{https://arxiv.org/abs/1311.6238}
}
\seealso{
the CDF function, \code{pconnorm}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
