% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_jk.R
\name{plot_jk}
\alias{plot_jk}
\title{Jackkniffe plot for variable contribution}
\usage{
plot_jk(x, metric = "ROC_AUC", legend = TRUE,
        colors = c("cyan", "blue", "red"),
        xlab = NULL, main = NULL)
}
\arguments{
\item{x}{list output from \code{\link{jackknife}}.}

\item{metric}{(character) model metric to plot. Default = "ROC_AUC".}

\item{legend}{(logical) whether to add legend. Default = TRUE.}

\item{colors}{(character) vector of colors.
Default = c("cyan", "blue", "red").}

\item{xlab}{(character) a label for the x axis.}

\item{main}{(character) main title for the plot.}
}
\description{
The jackknife figure shows the impact of each variable on the full model,
providing detailed information about the function and significance of each
variable. Light blue indicates the impact on the model if the variable is not
included, while dark blue indicates the independent contribution of the
variable to the model.
}
