% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{model_selection}
\alias{model_selection}
\title{Selection of best candidate models considering various criteria}
\usage{
model_selection(evaluation_stats, criterion = "TSS", exclude_bimodal = FALSE,
                tolerance = 0.01)
}
\arguments{
\item{evaluation_stats}{data.frame with the statistics of model evaluation
results. These results are the output of the function
\code{\link{evaluation_stats}}.}

\item{criterion}{(character) metric used as the predictive criterion for
model selection.}

\item{exclude_bimodal}{(logical) whether to exclude models in which binomial
variable response curves were detected.}

\item{tolerance}{(numeric)}
}
\value{
A data.frame with one or more selected models.
}
\description{
Applies a series of criteria to select best candidate models.
}
\examples{
# data
data("cal_res", package = "enmpa")
eval_stats <- cal_res$summary[, -1]

# selecting best model
selected_mod <- model_selection(eval_stats, exclude_bimodal = TRUE)
}
