% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{eia_data}
\alias{eia_data}
\title{EIA data}
\usage{
eia_data(
  dir,
  data = NULL,
  facets = NULL,
  freq = NULL,
  start = NULL,
  end = NULL,
  sort = NULL,
  length = NULL,
  offset = NULL,
  tidy = TRUE,
  check_metadata = FALSE,
  cache = TRUE,
  key = eia_get_key()
)
}
\arguments{
\item{dir}{character, directory path.}

\item{data}{character or \code{NULL},
\itemize{
\item note: if \code{NULL}, \code{eia_data()} will only return column headings; must input a character value
as provided by \code{eia_metadata()} for data to be returned.
\item see details.
}}

\item{facets}{character list or \code{NULL}, see details.}

\item{freq}{character or \code{NULL}, see details.}

\item{start, end}{character or \code{NULL}, see details.}

\item{sort}{named list of two.
\itemize{
\item \code{cols}: list column names on which to sort.
\item \code{order}: \code{"asc"} or \code{"desc"} for ascending or descending, respectively.
}}

\item{length}{numeric or \code{NULL}, number of rows to return.}

\item{offset}{numeric or \code{NULL}, number of rows to skip before return.}

\item{tidy}{logical or \code{NULL}, return a tidier result. See details.}

\item{check_metadata}{logical, if \code{TRUE} checks input values against metadata endpoint.}

\item{cache}{logical, cache result for duration of R session using memoization.
See details.}

\item{key}{API key: character if set explicitly; not needed if key is set
globally. See \code{eia_set_key()}.}
}
\value{
data frame
}
\description{
Obtain data from the EIA.
}
\details{
By default, \code{data}, \code{facets}, and \code{freq} are set to \code{NULL}. To obtain valid
input values for each of these arguments, use the specific ID labels
as provided by \code{eia_metadata()}.

The use of \code{start} and \code{end} require some input to \code{freq}.
By default (\code{check_metadata = FALSE}), the resulting data will match the
temporal resolution provided to \code{freq}, however, \code{check_metadata = TRUE} applies
further restrictions such that the format of values provided to \code{start}/\code{end} must match
that of \code{freq}. Furthermore, regardless of the input format provided to \code{start}/\code{end},
the resulting data will always match the specification of \code{freq}. And lastly,
regardless of chosen format, \code{end} must be strictly greater than \code{start} to return data.

By default, additional processing is done to return a list containing tibble data frames.
Set \code{tidy = FALSE} to return only the initial list result of \code{jsonlite::fromJSON}.
Set \code{tidy = NA} to return the original JSON as a character string.

Set to \code{cache = FALSE} to force a new API call for updated data.
Using \code{FALSE} always makes a new API call and returns the result from the server.
\code{TRUE} uses memoization on a per R session basis, caching the result of the
function call in memory for the duration of the R session.
You can reset the entire cache by calling \code{eia_clear_cache()}.
}
\examples{
\dontrun{
eia_data(
  dir = "electricity/retail-sales",
  data = "price",
  facets = list(sectorid = c("COM", "RES"), stateid = "OH")
)
}
}
