% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secp.R
\name{secp}
\alias{secp}
\title{Survival function}
\usage{
secp(q, lambda, gamma, phi, lower_tail = FALSE, cum_haz = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{lambda, gamma}{parameter values > 0.}

\item{phi}{parameter value != 0.}

\item{lower_tail}{similar to lower.tail}

\item{cum_haz}{logical value}
}
\value{
Numeric value of the survival function.

If lower_tail = TRUE, numeric value of the distribution function.

If cum_haz = TRUE, numeric value of the cumulative hazard function.
}
\description{
Compute the survival function of the extended Chen-Poisson (ecp)
distribution.
}
\examples{

secp(2, 1, 1, 1, lower_tail = FALSE, cum_haz = FALSE) # survival function
secp(2, 1, 1, 1, lower_tail = TRUE, cum_haz = FALSE) # distribution function
secp(2, 1, 1, 1, lower_tail = FALSE, cum_haz = TRUE) # cumulative
# hazard function

}
