#' Berberis aquifolium Invasive Species Management Treatment Data
#'
#' Experimental data from a management treatment study of invasive Berberis 
#' aquifolium (Oregon grape) plants conducted across four heavily infested 
#' dune sites in Belgium. The study evaluated the effectiveness of different 
#' management treatments on individual plants, with regrowth assessments 
#' conducted at 6 months and 1 year post-treatment.
#'
#' @format A data frame with 127 rows and 14 variables:
#' \describe{
#'   \item{plant_id}{Character, unique identifier for each B. aquifolium plant/clone}
#'   \item{region}{Factor, field code identifying the dune site location}
#'   \item{date}{Date, when the plant was initially located and treated (April/May 2013)}
#'   \item{treatment}{Factor, management treatment applied:
#'     \itemize{
#'       \item Manual digging - Uprooting by digging with shovels
#'       \item Leaf spray (glyphosate) - 5\% Roundup Max foliar application
#'       \item Stem cut + glyphosate - Cut and paint with 5\% glyphosate
#'       \item Stem cut + salt - Cut and treat with saturated NaCl solution
#'     }}
#'   \item{height}{Integer, plant height in centimeters}
#'   \item{diameter}{Integer, clone diameter in centimeters}
#'   \item{n_stems}{Integer, number of stems per individual plant/clone}
#'   \item{date_regrowth}{Date, date of regrowth assessment}
#'   \item{regrowth}{Ordered factor, stem regrowth response (Dead < Limited < Vital)}
#'   \item{x_proj}{Numeric, X-coordinate of plant location (GPS projection)}
#'   \item{y_proj}{Numeric, Y-coordinate of plant location (GPS projection)}
#'   \item{days_to_assessment}{Numeric, days between treatment and assessment}
#'   \item{treatment_success}{Factor, binary outcome (Success/Failure)}
#'   \item{volume_approx}{Numeric, approximate plant volume}
#' }
#' @source Adriaens, T., Verschelde, P., Cartuyvels, E., D'hondt, B., 
#'   Vercruysse, E., Gompel, W.V., Dewulf, E., & Provoost, S. (2019). 
#'   Data from: A preliminary field trial to compare control techniques for 
#'   invasive Berberis aquifolium in Belgian coastal dunes. Dryad Digital 
#'   Repository. \doi{10.5061/DRYAD.ZKH189361}
#' @examples
#' \donttest{
#' # Load the dataset
#' data(berberis_treatment)
#' 
#' # Treatment effectiveness summary
#' table(berberis_treatment$treatment, berberis_treatment$regrowth)
#' 
#' # Visualize treatment effectiveness
#' barplot(table(berberis_treatment$treatment, berberis_treatment$regrowth),
#'         beside = TRUE, legend = TRUE,
#'         main = "Treatment Effectiveness for Invasive Berberis")
#' }
"berberis_treatment"