% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findUndisputed.R
\name{findUndisputed}
\alias{findUndisputed}
\title{Undisputed identifications in a DVI problem}
\usage{
findUndisputed(
  dvi,
  pairings = NULL,
  ignoreSex = FALSE,
  threshold = 10000,
  strict = FALSE,
  relax = !strict,
  limit = 0,
  nkeep = NULL,
  numCores = 1,
  verbose = TRUE
)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{pairings}{A list of possible pairings for each victim. If NULL, all
sex-consistent pairings are used.}

\item{ignoreSex}{A logical.}

\item{threshold}{A non-negative number. If no pairwise LR exceed this, the
iteration stops.}

\item{strict}{A logical affecting the definition of being undisputed (see
Details). Default: FALSE.}

\item{relax}{Deprecated; use \code{strict = FALSE} instead.}

\item{limit}{A positive number. Only pairwise LR values above this are
considered.}

\item{nkeep}{An integer, or NULL. If given, only the \code{nkeep} most likely
pairings are kept for each victim.}

\item{numCores}{An integer; the number of cores used in parallelisation.
Default: 1.}

\item{verbose}{A logical. Default: TRUE.}
}
\value{
A list with the following entries:
\itemize{
\item \code{dviReduced}: A reduced version of \code{dvi}, where undisputed
victims/missing persons are removed, and data from undisputed victims
inserted into the reference data.
\item \code{summary}: A data frame summarising the undisputed matches.
\item \code{LRmatrix}: Output from \code{pairwiseLR()} applied to
the reduced problem.
}
}
\description{
This function uses the pairwise LR matrix to find \emph{undisputed} matches
between victims and missing individuals. An identification \eqn{V_i = M_j} is
called undisputed, relative to a threshold T, if the corresponding likelihood
ratio \eqn{LR_{i,j} \geq T} AND \eqn{LR_{i,j}} is at least T times greater
than all other pairwise LRs involving \eqn{V_i} or \eqn{M_j}.
}
\details{
If the parameter \code{strict} is set to TRUE, the last criterion is replaced with
the stronger requirement that all other pairwise LRs involving \eqn{V_i} or
\eqn{M_j} must be at most 1.
}
\examples{

\donttest{
u1 = findUndisputed(planecrash, verbose = FALSE)
u1$summary 

# With `strict = TRUE`, the match M3 = V2 goes away
u2 = findUndisputed(planecrash, strict = TRUE, verbose = FALSE)
u2$summary

# Reason: M3 has LR > 1 also against V7
u2$LRmatrix[, "M3"] |> round(2)
}

}
\seealso{
\code{\link[=pairwiseLR]{pairwiseLR()}}, \code{\link[=findExcluded]{findExcluded()}}
}
