% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gamma_poisson_clough}
\alias{gamma_poisson_clough}
\title{Compute posterior probability using a Gamma-Poisson model (Clough et al.)}
\usage{
gamma_poisson_clough(object, n_start, n_end, a = 1, b = 1e-10)
}
\arguments{
\item{object}{object of class \code{Counts}}

\item{n_start}{start of prior support range}

\item{n_end}{end of prior support range}

\item{a}{prior shape parameter of the gamma distribution used to compute the posterior with Clough. Default to 1}

\item{b}{prior rate parameter of the gamma distribution used to compute the posterior with Clough. Default to 1e-10}
}
\value{
vector of posterior probabilities
}
\description{
Compute posterior probability using a Gamma-Poisson model (Clough et al.)
}
\note{
if support range spans more than 100k values, the posterior is not
computed
}
