% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_measure.R
\name{ddbs_area}
\alias{ddbs_area}
\title{Calculates the area of geometries}
\usage{
ddbs_area(
  x,
  conn = NULL,
  name = NULL,
  new_column = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{x}{An \code{sf} spatial object. Alternatively, it can be a string with the
name of a table with geometry column within the DuckDB database \code{conn}.
Data is returned from this object.}

\item{conn}{A connection object to a DuckDB database. If \code{NULL}, the function
runs on a temporary DuckDB database.}

\item{name}{A character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table
names. If \code{NULL} (the default), the function returns the result as an
\code{sf} object}

\item{new_column}{Name of the new column to create on the input data. If NULL,
the function will return a vector with the result}

\item{crs}{The coordinates reference system of the data. Specify if the data
doesn't have a \code{crs_column}, and you know the CRS.}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}).
Set to \code{NULL} if absent.}

\item{overwrite}{Boolean. whether to overwrite the existing table if it exists. Defaults
to \code{FALSE}. This argument is ignored when \code{name} is \code{NULL}.}

\item{quiet}{A logical value. If \code{TRUE}, suppresses any informational messages.
Defaults to \code{FALSE}.}
}
\value{
a vector, an \code{sf} object or \code{TRUE} (invisibly) for table creation
}
\description{
Calculates the area of geometries from a DuckDB table or a \code{sf} object
Returns the result as an \code{sf} object with an area column or creates a new table in the database.
Note: Area units depend on the CRS of the input geometries (e.g., square meters for projected CRS,
or degrees for geographic CRS).
}
\examples{
\dontrun{
## load packages
library(duckspatial)
library(sf)

# create a duckdb database in memory (with spatial extension)
conn <- ddbs_create_conn(dbdir = "memory")

## read data
argentina_sf <- st_read(system.file("spatial/argentina.geojson", package = "duckspatial")) |>
    st_transform("EPSG:3857")

## store in duckdb
ddbs_write_vector(conn, argentina_sf, "argentina")

## calculate area (returns sf object with area column)
ddbs_area("argentina", conn)

## calculate area with custom column name
ddbs_area("argentina", conn, new_column = "area_sqm")

## create a new table with area calculations
ddbs_area("argentina", conn, name = "argentina_with_area")

## calculate area in a sf object
ddbs_area(argentina_sf)
}
}
