% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtcwt.R
\name{dualtree-transform}
\alias{dualtree-transform}
\alias{dtcwt}
\alias{idtcwt}
\title{The 2D forward and inverse dualtree complex wavelet transform}
\usage{
dtcwt(fld, fb1 = near_sym_b, fb2 = qshift_b, J = NULL, dec = TRUE,
  verbose = FALSE)

idtcwt(pyr, fb1 = near_sym_b, fb2 = qshift_b, verbose = TRUE)
}
\arguments{
\item{fld}{real matrix representing the field to be transformed}

\item{fb1}{A list of filter coefficients for the first level. Currently only \code{near_sym_b} and \code{near_sym_b_bp} are implemented}

\item{fb2}{A list of filter coefficients for all following levels. Currently only \code{qshift_b} and \code{qshift_b_bp} are implemented}

\item{J}{number of levels for the decomposition. Defaults to \code{log2( min(Nx,Ny) )} in the decimated case and \code{log2( min(Nx,Ny) ) - 3} otherwise}

\item{dec}{whether or not the decimated transform is desired}

\item{verbose}{if TRUE, the function tells you which level it is working on}

\item{pyr}{a list containing arrays of complex coefficients for each level of the decomposition, produced by \code{dtcwt( ..., dec=TRUE )}}
}
\value{
if dec=TRUE a list of complex coefficient fields, otherwise a complex \code{J x Nx x Ny x 6} array.
}
\description{
These functions perform the dualtree complex wavelet analysis and synthesis, either with or without decimation.
}
\details{
This is the 2D complex dualtree wavelet transform as described by Selesnick et al. (2005). It consists of four discerete wavelet transform trees, generated from two filter banks a and b by applying one set of filters to the rows and another (or the same) one to the columns. The 12 resulting coefficients are combined into six complex values representing six directions (15°, 45°, 75°, 105°, 135°, 165°). 
In the decimated case (dec=TRUE), each convolution is followed by a downsampling by two, meaining that the size of the six coefficient fields is cut in half at each level. The decimated transform can be reversed to recover the original image. For the \code{near_sym_b} and \code{qshift_b} filter banks, this reconstrcution should be basically perfect. In the case of the the \code{b_bp} filters, non-negligible artifacts appear near +-45° edges.
}
\note{
At present, the inverse transform only works if the input image had dimensions \code{2^N x 2^N}. You can use \code{\link{boundaries}} to achieve that.
}
\examples{
oldpar <- par( no.readonly=TRUE )
# forward transform
dt <- dtcwt( blossom )
par( mfrow=c(2,3), mar=rep(2,4) )
for( j in 1:6 ){
    image( blossom, col=grey.colors(32,0,1) )
    contour( Mod( dt[[3]][ ,,j ] )**2, add=TRUE, col="green" )
} 
par( oldpar ) 

# exmaple for the inverse transform
blossom_i <- idtcwt( dt )
image( blossom - blossom_i )

# example for a non-square case
boy <- blossom[50:120, 50:150]
bc  <- put_in_mirror(boy, 128)
dt  <- dtcwt(bc$res)
idt <- idtcwt(dt)[ bc$px, bc$py ]
}
\references{
Kingsbury, Nick (1999) <doi:10.1098/rsta.1999.0447>.
Selesnick, I.W., R.G. Baraniuk, and N.C. Kingsbury (2005) <doi:10.1109/MSP.2005.1550194>
}
\seealso{
\code{\link{filterbanks}}, \code{\link{fld2dt}}
}
\author{
Nick Kingsbury (canonical MATLAB implementation), Rich Wareham (open source Python implementation, \url{https://github.com/rjw57/dtcwt}), Sebastian Buschow (R port).
}
