% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.dtComb.R
\name{predict.dtComb}
\alias{predict.dtComb}
\title{Predict combination scores and labels for new data sets using the
training model}
\usage{
\method{predict}{dtComb}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{a \code{list} object where the parameters from the training
model are saved.}

\item{newdata}{a \code{numeric} new data set that includes biomarkers that
have not been introduced to the model before.}

\item{\dots}{further arguments. Currently has no effect on the results.}
}
\value{
A \code{data.frame} predicted combination scores (or probabilities)
and labels
}
\description{
The \code{predict.dtComb} is a function that generates predictions
for a new dataset of biomarkers using the parameters from the fitted model.
The function takes arguments newdata and model. The function's output is the
combination scores and labels of object type.
}
\examples{

# call data
data(laparotomy)

# define the function parameters
markers <- laparotomy[, -1]
status <- factor(laparotomy$group, levels = c("not_needed", "needed"))
event <- "needed"

score1 <- linComb(
  markers = markers, status = status, event = event,
  method = "logistic", resample = "none",
  standardize = "none", direction = "<", cutoff.method = "Youden"
)

comb.score1 <- predict(score1, markers)

score2 <- nonlinComb(
  markers = markers, status = status, event = "needed", include.interact = TRUE,
  method = "polyreg", resample = "repeatedcv", nfolds = 5,
  nrepeats = 10, cutoff.method = "Youden", direction = "auto"
)

comb.score2 <- predict(score2, markers)

score3 <- mathComb(
  markers = markers, status = status, event = event,
  method = "distance", distance = "euclidean", direction = "auto",
  standardize = "tScore", cutoff.method = "Youden"
)

comb.score3 <- predict(score3, markers)

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
