% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlFunctions.R
\name{gammaControl}
\alias{gammaControl}
\title{Control Function for Gamma Method Confidence Intervals}
\usage{
gammaControl(
  midp = FALSE,
  nmc = 0,
  wmtype = c("max", "mean", "minmaxavg", "tcz"),
  unirootTolFactor = 1e-06,
  ...
)
}
\arguments{
\item{midp}{logical. Use mid-p confidence distribution method? Currently
only implemented where \code{wmtype = "max"}}

\item{nmc}{Calculation method when \code{midp = TRUE}.}

\item{wmtype}{type of modification for the Gamma confidence interval.}

\item{unirootTolFactor}{tolerance factor for uniroot where \code{midp = TRUE}
and \code{nmc = 0}.}

\item{...}{Currently ignored.}
}
\value{
A list of arguments to pass to \code{\link[asht]{wspoissonTest}}.

If \code{midp = TRUE}, with values
\item{midp}{}
\item{nmc}{}
\item{unirootTolFactor}{}

If \code{midp = FALSE}, with values:
\item{\code{wmtype}}{}
}
\description{
Provides a list of arguments to pass to
\code{\link[asht]{wspoissonTest}}.
}
\seealso{
\code{\link[asht]{wspoissonTest}}
}
